// SchduleRecordDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScheduleRecording.h"
#include "SchduleRecordDlg.h"
#include "SetupDialog.h"
#include "afxdialogex.h"


// CSchduleRecordDlg dialog

IMPLEMENT_DYNAMIC(CSchduleRecordDlg, CDialogEx)

CSchduleRecordDlg::CSchduleRecordDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSchduleRecordDlg::IDD, pParent)
{
	m_nChannelID = -1;
}

CSchduleRecordDlg::~CSchduleRecordDlg()
{
}

void CSchduleRecordDlg::DoDataExchange(CDataExchange* pDX)
{	
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSchduleRecordDlg)
	DDX_Control(pDX, IDC_LIST_SCHEDULE_INFO, m_ListScheduleInfo);
	DDX_Control(pDX, IDC_COMBO_SCHEDULE_FREQUENCY, m_comboboxFrequency);
	DDX_Control(pDX, IDC_COMBO_SCHEDULE_WEEKLY, m_comboboxWeekly);
	DDX_DateTimeCtrl(pDX, IDC_DATE_PICKER, m_timeDaily);
	DDX_DateTimeCtrl(pDX, IDC_START_TIME_PICKER, m_timeStartTime);
	DDX_DateTimeCtrl(pDX, IDC_STOP_TIME_PICKER, m_timeStopTime);	
	//}}AFX_DATA_MAP	
}

BEGIN_MESSAGE_MAP(CSchduleRecordDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_INSERT, &CSchduleRecordDlg::OnBnClickedBtnInsert)
	ON_BN_CLICKED(IDC_BTN_DELETE, &CSchduleRecordDlg::OnBnClickedBtnDelete)
	ON_BN_CLICKED(IDCANCEL, &CSchduleRecordDlg::OnBnClickedCancel)
	ON_BN_CLICKED(IDOK, &CSchduleRecordDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CSchduleRecordDlg message handlers

BOOL CSchduleRecordDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	CenterWindow( this );

	m_comboboxFrequency.AddString( "ONCE" );

	m_comboboxFrequency.AddString( "DAILY" );

	m_comboboxFrequency.AddString( "WEEKLY" );

	m_comboboxFrequency.SetCurSel( 0 );

	m_comboboxWeekly.AddString( "Sunday" );

	m_comboboxWeekly.AddString( "Monday" );

	m_comboboxWeekly.AddString( "Tuesday" );

	m_comboboxWeekly.AddString( "Wednesday" );

	m_comboboxWeekly.AddString( "Thursday" );

	m_comboboxWeekly.AddString( "Friday" );

	m_comboboxWeekly.AddString( "Saturday" );

	m_comboboxWeekly.SetCurSel( 1 );

	CWnd * pwnd = GetDlgItem( IDC_LIST_SCHEDULE_INFO );

	HWND hWnd = pwnd->GetSafeHwnd();

	m_ListScheduleInfo.DeleteAllItems();

	LV_COLUMN lvc_col_name1 = { LVCF_FMT | LVCF_WIDTH | LVCF_SUBITEM | LVCF_TEXT, LVCFMT_LEFT, 100, _T("Frequency"), 0, 0 };

	m_ListScheduleInfo.InsertColumn( 0, &lvc_col_name1 );

	LV_COLUMN lvc_col_name2 = { LVCF_FMT | LVCF_WIDTH | LVCF_SUBITEM | LVCF_TEXT, LVCFMT_LEFT, 100, _T("Date or Weekly"), 0, 1 };

	m_ListScheduleInfo.InsertColumn( 1,  &lvc_col_name2 );

	LV_COLUMN lvc_col_name3 = { LVCF_FMT | LVCF_WIDTH | LVCF_SUBITEM | LVCF_TEXT, LVCFMT_LEFT, 150, _T("Start Time"), 0, 2 };

	m_ListScheduleInfo.InsertColumn( 2,  &lvc_col_name3 );

	LV_COLUMN lvc_col_name4 = { LVCF_FMT | LVCF_WIDTH | LVCF_SUBITEM | LVCF_TEXT, LVCFMT_LEFT, 150, _T("Stop Time"), 0, 3 };

	m_ListScheduleInfo.InsertColumn( 3,  &lvc_col_name4 );

	LV_COLUMN lvc_col_name5 = { LVCF_FMT | LVCF_WIDTH | LVCF_SUBITEM | LVCF_TEXT, LVCFMT_LEFT, 150, _T("Interval Time"), 0, 4 };

	m_ListScheduleInfo.InsertColumn( 4,  &lvc_col_name5 );	
	
	m_ListScheduleInfo.SetExtendedStyle( LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT ); 

	m_ListScheduleInfo.SetBkColor( RGB( 0xFF, 0xFF, 0xFF ) );

	CTime currtime1( CTime::GetCurrentTime() );

	m_timeDaily = currtime1;

	m_timeStartTime = currtime1;
	
	SYSTEMTIME sCurrSystemTimes;  GetLocalTime( &sCurrSystemTimes );

	sCurrSystemTimes.wHour += 1;

	CTime currtime2( sCurrSystemTimes );

	m_timeStopTime = currtime2;

	UpdateData( FALSE );

	CString strCapion;

	strCapion.Format( "SCHEDULE RECORDING - CH%02d", m_nChannelID + 1 );

	SetWindowText( strCapion );	

	ULONG i = 0;	

	// SET SCHEDULE DATA TO UI
	//
	SCHEDULE_INFO s_schedule_info;

	ULONG nFrequencyType = 0;

	ULONGLONG nStartTime = 0, nStopTime = 0;

	SYSTEMTIME sStartTime, sStopTime;

	CHAR pszText[ 256 ];

	LV_ITEM tvi;

	for( i = 0 ; i < m_oScheduleArray[ m_nChannelID ].GetSize() ; i++ )
	{
		s_schedule_info = m_oScheduleArray[ m_nChannelID ].ElementAt( i );

		sStartTime = s_schedule_info.sStartTime;

		nStartTime = s_schedule_info.nStartTime;

		sStopTime = s_schedule_info.sStopTime;

		nStopTime = s_schedule_info.nStopTime;

		ULONG j = m_ListScheduleInfo.GetItemCount();

		if ( s_schedule_info.nFrequencyType == 0 )
		{
			tvi.mask = LVIF_TEXT; tvi.pszText = "ONCE"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 0;

			m_ListScheduleInfo.InsertItem( &tvi );

			m_ListScheduleInfo.SetItem( &tvi );			

			sprintf( pszText, "%04d.%02d.%02d", sStartTime.wYear, sStartTime.wMonth, sStartTime.wDay );

			tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 1;

			m_ListScheduleInfo.InsertItem( &tvi );

			m_ListScheduleInfo.SetItem( &tvi );
		}

		if (  s_schedule_info.nFrequencyType == 1 )
		{
			tvi.mask = LVIF_TEXT; tvi.pszText = "DAILY"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 0;

			m_ListScheduleInfo.InsertItem( &tvi );

			m_ListScheduleInfo.SetItem( &tvi );

			tvi.mask = LVIF_TEXT; tvi.pszText = "DAILY"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 1;

			m_ListScheduleInfo.InsertItem( &tvi );

			m_ListScheduleInfo.SetItem( &tvi );
		}

		if (  s_schedule_info.nFrequencyType == 2 )
		{
			tvi.mask = LVIF_TEXT; tvi.pszText = "WEEKLY"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 0;

			m_ListScheduleInfo.InsertItem( &tvi );

			m_ListScheduleInfo.SetItem( &tvi );

			tvi.mask = LVIF_TEXT; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 1;

			if ( s_schedule_info.nWeeklyDay == 0 ) { tvi.pszText = "Sunday"; }

			if ( s_schedule_info.nWeeklyDay == 1 ) { tvi.pszText = "Monday"; }

			if ( s_schedule_info.nWeeklyDay == 2 ) { tvi.pszText = "Tuesday"; }

			if ( s_schedule_info.nWeeklyDay == 3 ) { tvi.pszText = "Wednesday"; }

			if ( s_schedule_info.nWeeklyDay == 4 ) { tvi.pszText = "Thursday"; }

			if ( s_schedule_info.nWeeklyDay == 5 ) { tvi.pszText = "Friday"; }

			if ( s_schedule_info.nWeeklyDay == 6 ) { tvi.pszText = "Saturday"; }			

			m_ListScheduleInfo.InsertItem( &tvi );

			m_ListScheduleInfo.SetItem( &tvi );
		}

		sprintf( pszText, "%02d HOUR %02d MINUTE", sStartTime.wHour, sStartTime.wMinute );

		tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 2;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );

		sprintf( pszText, "%02d HOUR %02d MINUTE", sStopTime.wHour, sStopTime.wMinute );

		tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 3;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );

		ULONG nIntervalMinutes = 0;

		CTime currtimeS( sStartTime );

		CTime currtimeE( sStopTime );
	
		CTimeSpan timeDiff; timeDiff = currtimeE - currtimeS;	

		nIntervalMinutes = (ULONG)timeDiff.GetTotalMinutes();

		sprintf( pszText, "%02d MINUTE", nIntervalMinutes );

		tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 4;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSchduleRecordDlg::OnPaint()
{	
	CDialogEx::OnPaint();
}

void CSchduleRecordDlg::OnDestroy() 
{	
}

void CSchduleRecordDlg::OnBnClickedBtnInsert()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	SYSTEMTIME systimeStartDay;

	m_timeDaily.GetAsSystemTime( systimeStartDay );

	SYSTEMTIME systimeStopTime;

	m_timeStopTime.GetAsSystemTime( systimeStopTime );

	SYSTEMTIME systimeStartTime;

	m_timeStartTime.GetAsSystemTime( systimeStartTime );

	if ( m_timeStartTime >=  m_timeStopTime ) { return; }

	// IF THE SAME INFO EXIST
	//
	BOOL bIsInfoExist = FALSE;

	ULONG i = 0;

	SCHEDULE_INFO s_schedule_info_oginal;

	SYSTEMTIME sStartSystemTimes_oginal, sStopSystemTimes_oginal;	

	for( i = 0 ; i < m_oScheduleArray[ m_nChannelID ].GetSize() ; i++ )
	{
		s_schedule_info_oginal = m_oScheduleArray[ m_nChannelID ].ElementAt( i );

		sStartSystemTimes_oginal = s_schedule_info_oginal.sStartTime;

		sStopSystemTimes_oginal = s_schedule_info_oginal.sStopTime;

		if ( s_schedule_info_oginal.nFrequencyType == 0 && m_comboboxFrequency.GetCurSel() == 0 ) // ONCE
		{
			if (  ( sStartSystemTimes_oginal.wYear == systimeStartDay.wYear && sStartSystemTimes_oginal.wMonth == systimeStartDay.wMonth &&  sStartSystemTimes_oginal.wDay == systimeStartDay.wDay && 

					sStartSystemTimes_oginal.wHour == systimeStartTime.wHour && sStartSystemTimes_oginal.wMinute == systimeStartTime.wMinute ) &&

					( sStopSystemTimes_oginal.wYear == systimeStartDay.wYear && sStopSystemTimes_oginal.wMonth == systimeStartDay.wMonth && sStopSystemTimes_oginal.wDay == systimeStartDay.wDay && 
						
						sStopSystemTimes_oginal.wHour == systimeStopTime.wHour && sStopSystemTimes_oginal.wMinute == systimeStopTime.wMinute ) )
			{
				bIsInfoExist = TRUE;

				break;
			}
		}

		if ( s_schedule_info_oginal.nFrequencyType == 1 && m_comboboxFrequency.GetCurSel() == 1 ) // DAILY
		{
			if (  ( sStartSystemTimes_oginal.wHour == systimeStartTime.wHour && sStartSystemTimes_oginal.wMinute == systimeStartTime.wMinute ) &&

					( sStopSystemTimes_oginal.wHour == systimeStopTime.wHour && sStopSystemTimes_oginal.wMinute == systimeStopTime.wMinute ) )
			{
				bIsInfoExist = TRUE;

				break;
			}
		}

		if ( s_schedule_info_oginal.nFrequencyType == 2 && m_comboboxFrequency.GetCurSel() == 2 ) // WEEKLY
		{
			if ( s_schedule_info_oginal.nWeeklyDay == m_comboboxWeekly.GetCurSel() )
			{
				if (  ( sStartSystemTimes_oginal.wHour == systimeStartTime.wHour && sStartSystemTimes_oginal.wMinute == systimeStartTime.wMinute ) &&

					( sStopSystemTimes_oginal.wHour == systimeStopTime.wHour && sStopSystemTimes_oginal.wMinute == systimeStopTime.wMinute ) )
				{
					bIsInfoExist = TRUE;

					break;
				}
			}
		}
	}

	if ( bIsInfoExist ) 
		return;
	//
	//

	CHAR pszText[ 256 ];

	LV_ITEM tvi;

	ULONG j = m_ListScheduleInfo.GetItemCount();

	if ( m_comboboxFrequency.GetCurSel() == 0 )
	{
		tvi.mask = LVIF_TEXT; tvi.pszText = "ONCE"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 0;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );		

		m_timeDaily.GetAsSystemTime( systimeStartDay );

		sprintf( pszText, "%04d.%02d.%02d", systimeStartDay.wYear, systimeStartDay.wMonth, systimeStartDay.wDay );

		tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 1;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );
	}

	if ( m_comboboxFrequency.GetCurSel() == 1 )
	{
		tvi.mask = LVIF_TEXT; tvi.pszText = "DAILY"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 0;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );

		tvi.mask = LVIF_TEXT; tvi.pszText = "DAILY"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 1;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );
	}

	if ( m_comboboxFrequency.GetCurSel() == 2 )
	{
		tvi.mask = LVIF_TEXT; tvi.pszText = "WEEKLY"; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 0;

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );

		tvi.mask = LVIF_TEXT; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 1;		

		if ( m_comboboxWeekly.GetCurSel() == 0 ) { tvi.pszText = "Sunday"; }

		if ( m_comboboxWeekly.GetCurSel() == 1 ) { tvi.pszText = "Monday"; }

		if ( m_comboboxWeekly.GetCurSel() == 2 ) { tvi.pszText = "Tuesday"; }

		if ( m_comboboxWeekly.GetCurSel() == 3 ) { tvi.pszText = "Wednesday"; }

		if ( m_comboboxWeekly.GetCurSel() == 4 ) { tvi.pszText = "Thursday"; }

		if ( m_comboboxWeekly.GetCurSel() == 5 ) { tvi.pszText = "Friday"; }

		if ( m_comboboxWeekly.GetCurSel() == 6 ) { tvi.pszText = "Saturday"; }		

		m_ListScheduleInfo.InsertItem( &tvi );

		m_ListScheduleInfo.SetItem( &tvi );
	}	

	sprintf( pszText, "%02d HOUR %02d MINUTE", systimeStartTime.wHour, systimeStartTime.wMinute );

	tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 2;

	m_ListScheduleInfo.InsertItem( &tvi );

	m_ListScheduleInfo.SetItem( &tvi );

	sprintf( pszText, "%02d HOUR %02d MINUTE", systimeStopTime.wHour, systimeStopTime.wMinute );

	tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 3;

	m_ListScheduleInfo.InsertItem( &tvi );

	m_ListScheduleInfo.SetItem( &tvi );

	ULONG nIntervalMinutes = 0;
	
	CTimeSpan timeDiff; timeDiff = m_timeStopTime - m_timeStartTime;	

	nIntervalMinutes = (ULONG)timeDiff.GetTotalMinutes();

	sprintf( pszText, "%02d MINUTE", nIntervalMinutes );

	tvi.mask = LVIF_TEXT; tvi.pszText = pszText; tvi.iItem = j; tvi.state = 0; tvi.stateMask = 0; tvi.lParam = j; tvi.iSubItem = 4;

	m_ListScheduleInfo.InsertItem( &tvi );

	m_ListScheduleInfo.SetItem( &tvi );

	// ADD TO MEMORY
	//
	SCHEDULE_INFO s_schedule_info;

	s_schedule_info.nFrequencyType =  m_comboboxFrequency.GetCurSel();

	SYSTEMTIME sStartSystemTimes, sStopSystemTimes;

	m_timeStartTime.GetAsSystemTime( sStartSystemTimes );

	m_timeStopTime.GetAsSystemTime( sStopSystemTimes );

	if ( m_comboboxFrequency.GetCurSel() == 0 )
	{
		sStartSystemTimes.wYear = systimeStartDay.wYear;

		sStartSystemTimes.wMonth =  systimeStartDay.wMonth;

		sStartSystemTimes.wDay = systimeStartDay.wDay;

		sStopSystemTimes.wYear = systimeStartDay.wYear;

		sStopSystemTimes.wMonth = systimeStartDay.wMonth;

		sStopSystemTimes.wDay = systimeStartDay.wDay;
	}	

	if ( m_comboboxFrequency.GetCurSel() == 2 )
	{
		if ( m_comboboxWeekly.GetCurSel() == 0 ) { sStartSystemTimes.wDayOfWeek = 0; sStopSystemTimes.wDayOfWeek = 0; }

		if ( m_comboboxWeekly.GetCurSel() == 1 ) { sStartSystemTimes.wDayOfWeek = 1; sStopSystemTimes.wDayOfWeek = 1; }

		if ( m_comboboxWeekly.GetCurSel() == 2 ) { sStartSystemTimes.wDayOfWeek = 2; sStopSystemTimes.wDayOfWeek = 2; }

		if ( m_comboboxWeekly.GetCurSel() == 3 ) { sStartSystemTimes.wDayOfWeek = 3; sStopSystemTimes.wDayOfWeek = 3; }

		if ( m_comboboxWeekly.GetCurSel() == 4 ) { sStartSystemTimes.wDayOfWeek = 4; sStopSystemTimes.wDayOfWeek = 4; }

		if ( m_comboboxWeekly.GetCurSel() == 5 ) { sStartSystemTimes.wDayOfWeek = 5; sStopSystemTimes.wDayOfWeek = 5; }

		if ( m_comboboxWeekly.GetCurSel() == 6 ) { sStartSystemTimes.wDayOfWeek = 6; sStopSystemTimes.wDayOfWeek = 6; }	

		s_schedule_info.nWeeklyDay = sStartSystemTimes.wDayOfWeek;
	}

	ULONGLONG nStartTime = 0; 
	
	SystemTimeToFileTime( &sStartSystemTimes, (FILETIME *)(&nStartTime) );	

	ULONGLONG nStopTime = 0; 
	
	SystemTimeToFileTime( &sStopSystemTimes, (FILETIME *)(&nStopTime) );	

	s_schedule_info.nStartTime = nStartTime;

	s_schedule_info.nStopTime = nStopTime;

	if( s_schedule_info.nStartTime != 0 && s_schedule_info.nStopTime != 0 ) 
	{
		s_schedule_info.sStartTime = sStartSystemTimes;

		s_schedule_info.sStopTime = sStopSystemTimes;

		s_schedule_info.nSkip = 0x00000000;

		s_schedule_info.bIsRecording = FALSE;

		m_oScheduleArray[ m_nChannelID ].Add( s_schedule_info );
	}
}


void CSchduleRecordDlg::OnBnClickedBtnDelete()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	// DELETE FROM MEMORY
	//
	ULONG i = 0;

	ULONG nFrequencyType = 0;

	CString strFrequency, strDateWeekly, strStartTime, strStopTime;
	
	SCHEDULE_INFO s_schedule_info;

	SYSTEMTIME sStartTime, sStopTime;

	CString strStartHour, strStartMinute;

	int nStartHour = 0, nStartMinute = 0;

	CString strStopHour, strStopMinute;

	int nStopHour = 0, nStopMinute = 0;

	// DELETE FROM UI
	//
	POSITION pos = m_ListScheduleInfo.GetFirstSelectedItemPosition();

	int selected = -1;

	if (pos != NULL)
	{
		while (pos)
		{
			int nItem = m_ListScheduleInfo.GetNextSelectedItem( pos );
			
			strFrequency = m_ListScheduleInfo.GetItemText( nItem, 0 );

			if ( strFrequency == "ONCE" ) { nFrequencyType = 0; }

			if ( strFrequency == "DAILY" ) { nFrequencyType = 1; }

			if ( strFrequency == "WEEKLY" ) { nFrequencyType = 2; }

			strDateWeekly = m_ListScheduleInfo.GetItemText( nItem, 1 );
			
			strStartTime = m_ListScheduleInfo.GetItemText( nItem, 2 );

			strStartHour = strStartTime.Left( 2 );

			nStartHour = atoi( strStartHour );

			strStartMinute = strStartTime.Mid( 8, 2 );

			nStartMinute = atoi( strStartMinute );

			strStopTime = m_ListScheduleInfo.GetItemText( nItem, 3 );

			strStopHour = strStopTime.Left( 2 );

			nStopHour = atoi( strStopHour );

			strStopMinute = strStopTime.Mid( 8, 2 );

			nStopMinute = atoi( strStopMinute );

			// DELETE FROM MEMORY
			//
			for( i = 0 ; i < m_oScheduleArray[ m_nChannelID ].GetSize() ; i++ )
			{
				s_schedule_info = m_oScheduleArray[ m_nChannelID ].ElementAt( i );

				sStartTime = s_schedule_info.sStartTime;

				sStopTime = s_schedule_info.sStopTime;

				if ( s_schedule_info.nFrequencyType ==  nFrequencyType )
				{
					if ( ( sStartTime.wHour ==  nStartHour ) &&
						
						( sStartTime.wMinute == nStartMinute ) && 
						
						(  sStopTime.wHour ==  nStopHour ) && 
						
						(  sStopTime.wMinute ==  nStopMinute ) )
					{
						if ( s_schedule_info.bIsRecording )
						{
							CSetupDialog * pParent = (CSetupDialog *)(GetParent());

							pParent->StopRecordimg( m_nChannelID + IDC_BTN_STOP_RECORD_CH01 );
						}

						m_oScheduleArray[ m_nChannelID ].RemoveAt( i );

						break;
					}
				}
			}
			//
			//

			m_ListScheduleInfo.DeleteItem( nItem );
		}
	}		
}


void CSchduleRecordDlg::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	CDialogEx::OnCancel();
}


void CSchduleRecordDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	CDialogEx::OnOK();
}
